﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;

public partial class Admin_Template_Template_Refresh : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("网站后台", "网站后台", "网站后台", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            刷新模板();
        else
            生成模板();
    }

    private void 生成模板()
    {
        MoBan.Items.Add(new ListItem("[页面]内容页面", "0"));
        MoBan.Items.Add(new ListItem("[页面]社区页面", "1"));
        DirectoryInfo[] DIS = new DirectoryInfo(Server.MapPath("~/Template/Content/")).GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
            MoBan.Items.Add(new ListItem("[内容]"+DIS[i].Name,"Content/"+ DIS[i].Name));

        DIS = new DirectoryInfo(Server.MapPath("~/Template/Club/")).GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
            MoBan.Items.Add(new ListItem("[社区]"+DIS[i].Name, "Club/" + DIS[i].Name));
    }

    private void 刷新模板()
    {
        访问.验证权限("55");
        String 模板名称 = MoBan.SelectedValue;
        if (模板名称 == "" || 模板名称 == null)
            throw new Exception("必须选择其中的一项");

        bool 模板类型 = 模板名称.StartsWith("Content/");
        if (模板名称 == "0")
            重编译页面();
        else if (模板名称 == "1")
            重编译社区页面();
        else
            if (模板类型)
                重编译内容(模板名称.Substring(8));
            else
                重编译社区(模板名称.Substring(5));

        Label1.Text = "刷新模板成功";
    }

    private void 重编译页面()
    {
        生成ASPX文件(new DirectoryInfo(Server.MapPath("~/Template/Content/" + 程序.设置["默认模板"] + "/WapPage/")), "", 程序.设置["默认模板"].ToString());
    }

    private void 重编译社区页面()
    {
        生成ASPX文件(new DirectoryInfo(Server.MapPath("~/Template/Club/" + 程序.设置["默认社区模板"] + "/WapPage/")), "Club/", 程序.设置["默认社区模板"].ToString());
    }

    private void 生成ASPX文件(DirectoryInfo DI, String 位置, String 模板名称)
    {
        FileInfo[] FIS = DI.GetFiles("*.txt");

        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI = FIS[i];
            StreamReader 读取 = FI.OpenText();
            String 第一行内容 = 读取.ReadLine();
            String 编译类型 = 读取.ReadLine();
            String 文件内容 = 读取.ReadToEnd();
            读取.Close();

            bool 是否WAP = 第一行内容.StartsWith("wap_", StringComparison.OrdinalIgnoreCase);
            String _位置 = 是否WAP ? 第一行内容.Substring(4) : 第一行内容.Substring(3);

            String ASPX代码, CS代码;

            编译器 编译器 = new 编译器(this.Context, 访问.连接, 编译类型, 是否WAP);
            编译器.模板名称 = 模板名称;
            编译器.文件名称 = 程序.安装位置 + 位置 + FI.Name.Substring(0, FI.Name.Length - 4) + ".aspx";
            编译器.开始执行代码 = 编译器.开始执行代码.Replace("$所在位置$", _位置)
            .Replace("$内容类型$", "网站页面")
            .Replace("$内容小类型$", _位置);
            CS代码 = 编译器.编译(文件内容, 位置 + FI.Name.Substring(0, FI.Name.Length - 4), out ASPX代码);

            File.WriteAllText(Server.MapPath("~/" + 位置 + FI.Name.Substring(0, FI.Name.Length - 4) + ".aspx"),
                ASPX代码, Encoding.UTF8);
            File.WriteAllText(Server.MapPath("~/" + 位置 + FI.Name.Substring(0, FI.Name.Length - 4) + ".aspx.cs"),
                CS代码, Encoding.UTF8);
        }

        DirectoryInfo[] DIS = DI.GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
        {
            Directory.CreateDirectory(Server.MapPath("~/" + 位置 + DIS[i].Name));
            生成ASPX文件(DIS[i], 位置 + DIS[i].Name + "/", 模板名称);
        }
    }

    private void 重编译内容(String 模板名称)
    {
        重编译内容_Content(模板名称);
        重编译内容_Other(模板名称);
    }

    private void 重编译内容_Content(String 模板名称)
    {
        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 模板名称 + "/Content/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI = FIS[i];
            设置 设置 = new 设置(File.ReadAllText(FI.FullName));

            String 模板类型, 内容类型;
            模板类型 = 设置["模板类型"].ToString();
            内容类型 = 设置["内容类型"].ToString();
            int ID = Convert.ToInt32(设置["ID"]);

            编译器 编译器 = new 编译器(this.Context, 访问.连接, "内容模板/" + 模板类型 + "/" + 内容类型, Convert.ToBoolean(设置["是否WAP"]));
            编译器.模板名称 = 模板名称;
            编译器.开始执行代码 = 编译器.开始执行代码
            .Replace("$所在位置$", 模板类型)
            .Replace("$内容类型$", "其它")
            .Replace("$内容小类型$", 模板类型);
            编译器.文件名称 = "{$文件名称$}";
            String ASPX代码, CS代码;
            CS代码 = 编译器.编译(设置["代码内容"].ToString(), "{$文件夹$}/{$文件$}", out ASPX代码);
            File.WriteAllText(Server.MapPath("~/Template/Content/" + 模板名称 + "/Content_Aspx/" + ID + ".aspx"),
                ASPX代码.Replace("{$文件夹$}", "Template_Content_" + 模板名称 + "_Content_Aspx")
                    .Replace("{$文件$}", ID.ToString())
                    .Replace("{$ID$}", "0"),
                Encoding.UTF8);
            File.WriteAllText(Server.MapPath("~/Template/Content/" + 模板名称 + "/Content_Aspx/" + ID + ".aspx.cs"),
                CS代码.Replace("{$文件夹$}", "Template_Content_" + 模板名称 + "_Content_Aspx")
                    .Replace("{$文件$}", ID.ToString())
                    .Replace("{$ID$}", "0"),
                Encoding.UTF8);
        }
    }

    private void 重编译内容_Other(String 模板名称)
    {
        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 模板名称 + "/Other/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI = FIS[i];
            设置 设置 = new 设置(File.ReadAllText(FI.FullName));

            String 模板类型, 内容类型;
            模板类型 = 设置["模板类型"].ToString();
            int ID = Convert.ToInt32(设置["ID"]);

            编译器 编译器 = new 编译器(this.Context, 访问.连接, "其它模板/" + 模板类型, Convert.ToBoolean(设置["是否WAP"]));
            编译器.模板名称 = 模板名称;
            编译器.开始执行代码 = 编译器.开始执行代码
            .Replace("$所在位置$", 模板类型)
            .Replace("$内容类型$", "其它")
            .Replace("$内容小类型$", 模板类型);
            编译器.文件名称 = "{$文件名称$}";
            String ASPX代码, CS代码;
            CS代码 = 编译器.编译(设置["代码内容"].ToString(), "{$文件夹$}/{$文件$}", out ASPX代码);
            File.WriteAllText(Server.MapPath("~/Template/Content/" + 模板名称 + "/Other_Aspx/" + ID + ".aspx"),
                ASPX代码.Replace("{$文件夹$}", "Template_Content_" + 模板名称 + "_Other_Aspx")
                    .Replace("{$文件$}", ID.ToString())
                    .Replace("{$ID$}", "0"),
                Encoding.UTF8);
            File.WriteAllText(Server.MapPath("~/Template/Content/" + 模板名称 + "/Other_Aspx/" + ID + ".aspx.cs"),
                CS代码.Replace("{$文件夹$}", "Template_Content_" + 模板名称 + "_Other_Aspx")
                    .Replace("{$文件$}", ID.ToString())
                    .Replace("{$ID$}", "0"),
                Encoding.UTF8);
        }
    }

    private void 重编译社区(String 模板名称)
    {
        重编译社区_Club(模板名称);
    }

    private void 重编译社区_Club(String 模板名称)
    {
        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Club/" + 模板名称 + "/Club/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI = FIS[i];
            设置 设置 = new 设置(File.ReadAllText(FI.FullName));

            String 模板类型, 内容类型;
            模板类型 = 设置["模板类型"].ToString();
            int ID = Convert.ToInt32(设置["ID"]);

            编译器 编译器 = new 编译器(this.Context, 访问.连接, "社区模板/" + 模板类型 , Convert.ToBoolean(设置["是否WAP"]));
            编译器.模板名称 = 模板名称;
            编译器.开始执行代码 = 编译器.开始执行代码
            .Replace("$所在位置$", 模板类型)
            .Replace("$内容类型$", "其它")
            .Replace("$内容小类型$", 模板类型);
            编译器.文件名称 = "{$文件名称$}";
            String ASPX代码, CS代码;
            CS代码 = 编译器.编译(设置["代码内容"].ToString(), "{$文件夹$}/{$文件$}", out ASPX代码);
            File.WriteAllText(Server.MapPath("~/Template/Club/" + 模板名称 + "/Club_Aspx/" + ID + ".aspx"),
                ASPX代码.Replace("{$文件夹$}", "Template_Club_" + 模板名称 + "_Club_Aspx")
                    .Replace("{$文件$}", ID.ToString())
                    .Replace("{$ID$}", "0"),
                Encoding.UTF8);
            File.WriteAllText(Server.MapPath("~/Template/Club/" + 模板名称 + "/Club_Aspx/" + ID + ".aspx.cs"),
                CS代码.Replace("{$文件夹$}", "Template_Club_" + 模板名称 + "_Club_Aspx")
                    .Replace("{$文件$}", ID.ToString())
                    .Replace("{$ID$}", "0"),
                Encoding.UTF8);
        }
    }
}
